<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$plugin_name    = WOO_CONDITIOANAL_FEE_PLUGIN_NAME;
$plugin_version = WCPFC_PLUGIN_VERSION;
?>
<div id="dotsstoremain">
    <div class="all-pad">
        <header class="dots-header">
            <div class="dots-logo-main">
                <img src="<?php echo esc_url( WCPFC_PLUGIN_URL . 'admin/images/WooCommerce-Conditional-Product-Fees-For-Checkout.png' ); ?>"
                     alt="<?php esc_html_e( 'WooCommerce Conditional Product Fees For Checkout', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
            </div>
            <div class="dots-header-right">
                <div class="logo-detail">
                    <strong><?php esc_html_e( $plugin_name, 'woocommerce-conditional-product-fees-for-checkout' ); ?></strong>
                    <span><?php esc_html_e( 'Free Version ', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php echo esc_html( $this->version ); ?></span>
                </div>
                <div class="button-dots">
                    <span>
                        <a target="_blank"
                           href="<?php echo esc_url( 'store.multidots.com/woocommerce-conditional-product-fees-checkout' ); ?>">
                            <img src="<?php echo esc_url( WCPFC_PLUGIN_URL . 'admin/images/upgrade_new.png' ); ?>">
                        </a>
                    </span>
                    <span class="support_dotstore_image">
                        <a target="_blank"
                           href="<?php echo esc_url( 'store.multidots.com/dotstore-support-panel' ); ?>">
                            <img src="<?php echo esc_url( WCPFC_PLUGIN_URL . 'admin/images/support_new.png' ); ?>">
                        </a>
                    </span>
                </div>
            </div>

			<?php
			$fee_getting_started = '';
			$page_val            = filter_input( INPUT_GET, 'page', FILTER_SANITIZE_STRING );


			$fee_list = isset( $page_val ) && $page_val === 'wcpfc-list' ? 'active' : '';
			$fee_add  = isset( $page_val ) && $page_val === 'wcpfc-add-new' ? 'active' : '';
			if ( ! empty( $page_val ) && ( $page_val === 'wcpfc-get-started' ) ) {
				$fee_getting_started = 'active';
			}
			$premium_version = isset( $page_val ) && $page_val === 'wcpfc-premium' ? 'active' : '';
			$fee_information = isset( $page_val ) && $page_val === 'wcpfc-information' ? 'active' : '';

			if ( isset( $page_val ) && $page_val === 'wcpfc-information' || isset( $page_val ) && $page_val === 'wcpfc-get-started' ) {
				$fee_about = 'active';
			} else {
				$fee_about = '';
			}

			$action_val            = filter_input( INPUT_GET, 'action', FILTER_SANITIZE_STRING );

			if ( ! empty( $action_val ) ) {
				if ( $action_val === 'add' || $action_val === 'edit' ) {
					$fee_add = 'active';
				}
			}
			?>
            <div class="dots-menu-main">
                <nav>
                    <ul>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr( $fee_list ); ?>"
                               href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-list' ) ); ?>"><?php esc_html_e( 'Manage Product Fees', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr( $fee_add ); ?>"
                               href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-add-new' ) ); ?>"> <?php esc_html_e( 'Add Product Fees', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr( $fee_about ); ?>"
                               href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-get-started' ) ); ?>"><?php esc_html_e( 'About Plugin', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                            <ul class="sub-menu">
                                <li><a class="dotstore_plugin <?php echo esc_attr( $fee_getting_started ); ?>"
                                       href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-get-started' ) ); ?>"><?php esc_html_e( 'Getting Started', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                                <li><a class="dotstore_plugin <?php echo esc_attr( $fee_information ); ?>"
                                       href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-information' ) ); ?>"><?php esc_html_e( 'Quick info', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a class="dotstore_plugin <?php echo esc_attr( $premium_version ); ?>"
                               href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=wcpfc-premium' ) ); ?>"> <?php esc_html_e( 'Premium Version', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                        </li>
                        <li>
                            <a class="dotstore_plugin"><?php esc_html_e( 'Dotstore', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                            <ul class="sub-menu">
                                <li><a target="_blank"
                                       href="<?php echo esc_url( 'store.multidots.com/go/flatrate-pro-new-interface-woo-plugins' ); ?>"><?php esc_html_e( 'WooCommerce Plugins', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                                <li><a target="_blank"
                                       href="<?php echo esc_url( 'store.multidots.com/go/flatrate-pro-new-interface-wp-plugins' ); ?>"><?php esc_html_e( 'Wordpress Plugins', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                                <br>
                                <li><a target="_blank"
                                       href="<?php echo esc_url( 'store.multidots.com/go/flatrate-pro-new-interface-wp-free-plugins' ); ?>"><?php esc_html_e( 'Free Plugins', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                                <li><a target="_blank"
                                       href="<?php echo esc_url( 'store.multidots.com/go/flatrate-pro-new-interface-free-theme' ); ?>"><?php esc_html_e( 'Free Themes', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                                <li><a target="_blank"
                                       href="<?php echo esc_url( 'store.multidots.com/go/flatrate-pro-new-interface-dotstore-support' ); ?>"><?php esc_html_e( 'Contact Support', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </nav>
            </div>
        </header>