<?php

add_action( 'wp_enqueue_scripts', 'basel_child_enqueue_styles', 1000 );

function basel_child_enqueue_styles() {
	$version = basel_get_theme_info( 'Version' );

	if( basel_get_opt( 'minified_css' ) ) {
		wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.min.css', array('bootstrap'), $version );
	} else {
		wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.css', array('bootstrap'), $version );
	}

    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('bootstrap'), $version );
}

/*
Disable Variable Product Price Range:
*/

add_filter( 'woocommerce_variable_sale_price_html', 'my_variation_price_format', 10, 2 );

add_filter( 'woocommerce_variable_price_html', 'my_variation_price_format', 10, 2 );

function my_variation_price_format( $price, $product ) {

// Main Price
$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
$price = $prices[0] !== $prices[1] ? sprintf( __( 'pris från %1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

// Sale Price
$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
sort( $prices );
$saleprice = $prices[0] !== $prices[1] ? sprintf( __( 'pris från %1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

if ( $price !== $saleprice ) {
$price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
}
return $price;
}

/* Lakshan Html block after Shop page */
add_shortcode('ws_frame', 'ws_frontend_product_page_validate');
function ws_frontend_product_page_validate() {
//echo '<iframe src="http://www.example.com/" style="width: 100%; height: 100%;" scrolling="no" frameBorder="0"></iframe>';
	echo '<div class="Tours_Html_Block">';
  echo do_shortcode('[html_block id="1512"]');
	echo do_shortcode('[html_block id="1710"]');
	echo '</div>';


}

add_action( 'woocommerce_after_main_content', 'action_woocommerce_after_main_content', 10);

function action_woocommerce_after_main_content(){


    do_shortcode('[ws_frame]');
}
add_filter('woocommerce_product_single_add_to_cart_text', 'woo_custom_cart_button_text');

function woo_custom_cart_button_text() {
return __('boka', 'woocommerce');
}


/**
 * ------------------------------------------------------------------------------------------------
 * Show attribute swatches list
 * ------------------------------------------------------------------------------------------------
 */
if( ! function_exists( 'basel_swatches_list' ) ) {
    function basel_swatches_list( $attribute_name = false ) {
        global $product;

        $id = $product->get_id();

        if( empty( $id ) || ! $product->is_type( 'variable' ) ) return;

        if( ! $attribute_name ) {
            $attribute_name = basel_grid_swatches_attribute();
        }

        if( empty( $attribute_name ) ) return false;

        // Swatches cache
        $cache = apply_filters( 'basel_swatches_cache', true );
        $transient_name = 'basel_swatches_cache_' . $id;

        if ( $cache ) {
            $available_variations = get_transient( $transient_name );
        } else {
            $available_variations = array();
        }

        if ( ! $available_variations ) {
            $available_variations = $product->get_available_variations();
            if ( $cache ) {
                set_transient( $transient_name, $available_variations, apply_filters( 'basel_swatches_cache_time', WEEK_IN_SECONDS ) );
            }
        }

        if( empty( $available_variations ) ) return;

        $swatches_to_show = basel_get_option_variations(  $attribute_name, $available_variations, false, $id );

        if( empty( $swatches_to_show ) ) return;

        echo '<div class="swatches-on-grid">';

        $swatch_size = basel_wc_get_attribute_term( $attribute_name, 'swatch_size' );

        if( apply_filters( 'basel_swatches_on_grid_right_order', true ) ) {
            $terms = wc_get_product_terms( $product->get_id(), $attribute_name, array( 'fields' => 'slugs' ) );

            $swatches_to_show_tmp = $swatches_to_show;

            $swatches_to_show = array();

            foreach ($terms as $id => $slug) {
                if( ! isset( $swatches_to_show_tmp[$slug] ) ) continue;
                $swatches_to_show[$slug] = $swatches_to_show_tmp[$slug];
            }
        }

        $x=0;
        foreach ($swatches_to_show as $key => $swatch) {
            $style = $class = '';

            if( ! empty( $swatch['color'] )) {
                $style = 'background-color:' .  $swatch['color'];
            } else if( ! empty( $swatch['image'] ) ) {
                $style = 'background-image: url(' . $swatch['image'] . ')';
            } else if( ! empty( $swatch['not_dropdown'] ) ) {
                $class .= 'text-only ';
            }

            $style .= ';';

            $data = '';

            if( isset( $swatch['image_src'] ) ) {
                $class .= 'swatch-has-image';
                $data .= 'data-image-src="' . $swatch['image_src'] . '"';
                $data .= ' data-image-srcset="' . $swatch['image_srcset'] . '"';
                $data .= ' data-image-sizes="' . $swatch['image_sizes'] . '"';
                if( basel_get_opt( 'swatches_use_variation_images' ) ) {
                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $swatch['variation_id'] ), 'woocommerce_thumbnail');
                    if ( !empty( $thumb ) ) {
                        $style = 'background-image: url(' . $thumb[0] . ')';
                        $class .= ' variation-image-used';
                    }
                }

                if( ! $swatch['is_in_stock'] ) {
                    $class .= ' variation-out-of-stock';
                }
            }

            $class .= ' swatch-size-' . $swatch_size;

            $term = get_term_by( 'slug', $key, $attribute_name );

            // SET ALL ARE BOOKED MESSAGE

            global $product;

            $product_variations=$product->get_available_variations();
            foreach ($product_variations as $variation)  {
                $var_data = $variation['attributes'];
                $var_data['is_in_stock']=$variation['is_in_stock'];
            }

           //  print_r($var_data);

            //List all attributes with stock available or not array..
//        echo '<pre>';
//        echo('is in stock'.$var_data['is_in_stock']);
//        echo '</pre>';

//            if(($var_data['is_in_stock'] ==1) || ($var_data['is_in_stock'] =='1')){
//                $str_variable="";
//            }else{
//                $str_variable="FULLBOKAD";
//            }
    
           // print_r($swatch);

            if($var_data['is_in_stock']){
                $str_variable="";
            }else{
                $str_variable="FULLBOKAD";
            }

            // if($x==0){
                echo '<div class="swatch-on-grid basel-tooltip ' . esc_attr( $class ) . '" style="' . esc_attr( $style ) .'" ' . $data . '><div class="book_date book_date_w_book">' . $term->name . '</div><div class="is_full_booked">'.$str_variable.'</div></div>';
            // }else{
            //     echo '<div class="swatch-on-grid basel-tooltip ' . esc_attr( $class ) . '" style="' . esc_attr( $style ) .'" ' . $data . '><div class="book_date">' . $term->name . '</div></div>';
            // }
            // $x++;
        }

        echo '</div>';

    }
}