<?php
/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$items_to_show = 3;

do_action( 'woocommerce_before_mini_cart' ); ?>


	<?php if ( ! WC()->cart->is_empty() ) : ?>

		<ul class="woocommerce-mini-cart cart_list product_list_widget <?php echo esc_attr( $args['list_class'] ); ?>">

            <div class="cartDropheader">
                <div class="col-sm-5">
                    <h4>resa:</h4>
                </div>


                <div class="col-sm-4">
                    <h4>personer:</h4>
                </div>

                <div class="col-sm-2">
                    <h4>Pris:</h4>
                </div>
            </div>

			<?php
				do_action( 'woocommerce_before_mini_cart_contents' );

				foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
					$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
					$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

					if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
						$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
						$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );

                        $product = wc_get_product( $product_id );
                        
                        // $sum_product_count=($product->get_price()*($cart_item['quantity'])).' '.ucfirst(get_woocommerce_currency_symbol());
                        
                         $sum_product_count=wc_price($product->get_price()*($cart_item['quantity']));
                        
                        

                        $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
						?>

						<li class="woocommerce-mini-cart-item <?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
<!--							--><?php
//							echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
//								'<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">&times;</a>',
//								esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
//								esc_html__( 'Remove this item', 'woocommerce' ),
//								esc_attr( $product_id ),
//								esc_attr( $cart_item_key ),
//								esc_attr( $_product->get_sku() )
//							), $cart_item_key );
//
//							?>

                            <div class="whineCart">
                                <div class="col-sm-5">
                                    <?php if ( empty( $product_permalink ) ) : ?>
                                        <?php echo apply_filters( 'woocommerce_cart_item_thumbnail', $product_name ); ?>
                                    <?php else : ?>
                                        <a href="<?php echo esc_url( $product_permalink ); ?>">
                                            <?php echo apply_filters( 'woocommerce_cart_item_thumbnail', $product_name ); ?>
                                        </a>
                                    <?php endif; ?>
                                    <?php
                                    echo wc_get_formatted_cart_item_data( $cart_item );
                                    ?>
                                </div>

                                <div class="col-sm-4 quanDiv">
                                    <?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( $cart_item['quantity'] ) . '</span>', $cart_item, $cart_item_key ); ?>
                                </div>


                                <div class="col-sm-3">
                                    <?php
                                 //   var_dump($product_price);

                                    ?>
                                    <?php  //echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf($product_price) . '</span>', $cart_item, $cart_item_key );
                                   
                                  // print_r($cart_item);
                                    echo wc_price($cart_item['line_subtotal']);
                                    //  echo '<span class="woocommerce-Price-amount amount">'.$sum_product_count.'</span>';
                                     ?>
                                </div>
                            </div>

						</li>

						<?php
					}
				}

			do_action( 'woocommerce_mini_cart_contents' );

		?>

		</ul><!-- end product list -->

        <div class="col-sm-12">
            <div class="cartTextpara">
                <?php echo ot_get_option('cart_text_tours'); ?>
            </div>
        </div>

	<?php else : ?>

		<p class="woocommerce-mini-cart__empty-message empty"><?php _e( 'No products in the cart.', 'woocommerce' ); ?></p>

	<?php endif; ?>


<?php if ( ! WC()->cart->is_empty() ) : ?>

<div class="dropPrice">
    <p class="woocommerce-mini-cart__total total"><strong><?php _e( 'totalsumma', 'woocommerce' ); ?>:</strong> <?php echo WC()->cart->get_cart_subtotal(); ?></p>
</div>

    <div class="dropBtn">
        <?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>

        <p class="woocommerce-mini-cart__buttons buttons"><?php do_action( 'woocommerce_widget_shopping_cart_buttons' ); ?></p>
    </div>

<?php endif; ?>

<?php do_action( 'woocommerce_after_mini_cart' ); ?>
