<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
include dirname( __FILE__ ) . '/header/plugin-header.php';

$submit_fee = filter_input( INPUT_POST, 'submitFee', FILTER_SANITIZE_STRING );
$action = filter_input( INPUT_GET, 'action', FILTER_SANITIZE_STRING );
$p_id   = filter_input( INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT );

if ( isset( $submit_fee ) ) {

	$arr_post = filter_input_array( INPUT_POST );
	$post     = $arr_post;
	$this->wcpfc_fees_conditions_save( $post, $retrieved_nonce, $action );
}

if ( isset( $action ) && $action === 'edit' ) {
	$id = $p_id;
	$post_id          = $id;
	$btnValue         = __( 'Update', 'woocommerce-conditional-product-fees-for-checkout' );
	$fee_title        = __( get_the_title( $post_id ), 'woocommerce-conditional-product-fees-for-checkout' );
	$getFeesCost      = __( get_post_meta( $post_id, 'fee_settings_product_cost', true ), 'woocommerce-conditional-product-fees-for-checkout' );
	$getFeesPerQty    = get_post_meta( $post_id, 'fee_chk_qty_price', true );
	$getFeesType      = __( get_post_meta( $post_id, 'fee_settings_select_fee_type', true ), 'woocommerce-conditional-product-fees-for-checkout' );
	$getFeesStartDate = get_post_meta( $post_id, 'fee_settings_start_date', true );
	$getFeesEndDate   = get_post_meta( $post_id, 'fee_settings_end_date', true );
	$getFeesTaxable   = __( get_post_meta( $post_id, 'fee_settings_select_taxable', true ), 'woocommerce-conditional-product-fees-for-checkout' );
	$getFeesStatus    = get_post_meta( $post_id, 'fee_settings_status', true );
	$productFeesArray = get_post_meta( $post_id, 'product_fees_metabox', true );
	$getFeesOptional  = __( get_post_meta( $post_id, 'fee_settings_optional_gift', true ), 'woocommerce-conditional-product-fees-for-checkout' );
	$byDefaultChecked = get_post_meta( $post_id, 'by_default_checkbox_checked', true );
} else {
	$post_id          = '';
	$btnValue         = __( 'Submit', 'woocommerce-conditional-product-fees-for-checkout' );
	$fee_title        = '';
	$getFeesCost      = '';
	$getFeesPerQty    = '';
	$getFeesType      = '';
	$getFeesStartDate = '';
	$getFeesEndDate   = '';
	$getFeesTaxable   = '';
	$getFeesStatus    = '';
	$productFeesArray = array();
	$getFeesOptional  = '';
	$byDefaultChecked = '';
}
if ( $getFeesOptional === 'yes' ) {
	$style_display = 'display:block;';
} else {
	$style_display = 'display:none;';
}
?>
    <div class="text-condtion-is">
        <select class="text-condition">
            <option value="is_equal_to"><?php esc_html_e( 'Equal to ( = )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
            <option value="less_equal_to"><?php esc_html_e( 'Less or Equal to ( <= )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
            <option value="less_then"><?php esc_html_e( 'Less than ( < )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
            <option value="greater_equal_to"><?php esc_html_e( 'Greater or Equal to ( >= )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
            <option value="greater_then"><?php esc_html_e( 'Greater than ( > )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
            <option value="not_in"><?php esc_html_e( 'Not Equal to ( != )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
        </select>
        <select class="select-condition">
            <option value="is_equal_to"><?php esc_html_e( 'Equal to ( = )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
            <option value="not_in"><?php esc_html_e( 'Not Equal to ( != )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
        </select>
    </div>
    <div class="default-country-box">
		<?php
        $j = 0;
		$countries_obj = new WC_Countries();
		$getCountries  = $countries_obj->__get( 'countries' );
		?>
        <select name="fees[product_fees_conditions_values][value_<?php echo esc_attr( $j ); ?>][]"
                class="product_fees_conditions_values multiselect2 product_fees_conditions_values_country"
                multiple="multiple">
			<?php
			if ( ! empty( $getCountries ) ) {
				foreach ( $getCountries as $code => $country ) {
					?>
                    <option value="<?php echo esc_attr( $code ); ?>"><?php echo esc_html( $country ); ?></option>
					<?php
				}
			}
			?>
        </select>
		<?php
		?>
    </div>
    <div class="wcpfc-main-table res-cl">
        <h2><?php esc_html_e( 'Fee: Basic Configuration', 'woocommerce-conditional-product-fees-for-checkout' ); ?></h2>
        <form method="POST" name="feefrm" action="">
            <input type="hidden" name="post_type" value="wc_conditional_fee">
            <input type="hidden" name="fee_post_id" value="<?php echo esc_attr( $post_id ); ?>">
            <table class="form-table table-outer product-fee-table">
                <tbody>
                <tr valign="top">
                    <th class="titledesc" scope="row"><label
                                for="fee_settings_product_fee_title"><?php esc_html_e( 'Product Fee Title', 'woocommerce-conditional-product-fees-for-checkout' ); ?>
                            <span class="required-star">*</span></label></th>
                    <td class="forminp mdtooltip">
                        <input type="text" name="fee_settings_product_fee_title" class="text-class"
                               id="fee_settings_product_fee_title"
                               value="<?php echo isset( $fee_title ) ? esc_attr( $fee_title ) : ''; ?>" required="1"
                               placeholder="<?php esc_html_e( 'Enter product fees title', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                        <span class="woocommerce_conditional_product_fees_checkout_tab_descirtion"><i
                                    class="fa fa-question-circle " aria-hidden="true"></i></span>
                        <p class="description"><?php esc_html_e( 'This product fees title is visible to the customer at the time of checkout.', 'woocommerce-conditional-product-fees-for-checkout' ); ?></p>
                    </td>

                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label for="fee_settings_select_fee_type"><?php esc_html_e( 'Select Fee Type', 'woocommerce-conditional-product-fees-for-checkout' ); ?></label>
                    </th>
                    <td class="forminp mdtooltip">
                        <select name="fee_settings_select_fee_type" id="fee_settings_select_fee_type" class="">
                            <option value="fixed" <?php echo isset( $getFeesType ) && $getFeesType === 'fixed' ? 'selected="selected"' : '' ?>><?php esc_html_e( 'Fixed', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                            <option value="percentage" <?php echo isset( $getFeesType ) && $getFeesType === 'percentage' ? 'selected="selected"' : '' ?>><?php esc_html_e( 'Percentage', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                        </select>
                        <span class="woocommerce_conditional_product_fees_checkout_tab_descirtion"><i
                                    class="fa fa-question-circle " aria-hidden="true"></i></span>
                        <p class="description"><?php esc_html_e( 'you can charges extra fees on fixed price or percentage wise.', 'woocommerce-conditional-product-fees-for-checkout' ); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row"><label
                                for="fee_settings_product_cost"><?php esc_html_e( 'Fees&nbsp;(' . get_woocommerce_currency_symbol() . ') ', 'woocommerce-conditional-product-fees-for-checkout' ); ?>
                            <span class="required-star">*</span></label></th>
                    <td class="forminp mdtooltip">
                        <div class="product_cost_left_div">
                            <input type="text" name="fee_settings_product_cost" required="1" class="text-class"
                                   id="fee_settings_product_cost"
                                   value="<?php echo isset( $getFeesCost ) ? esc_attr( $getFeesCost ) : ''; ?>"
                                   placeholder="<?php esc_html_e( get_woocommerce_currency_symbol() ); ?>">
                            <span class="woocommerce_conditional_product_fees_checkout_tab_descirtion"><i
                                        class="fa fa-question-circle " aria-hidden="true"></i></span>
                            <p class="description">
								<?php esc_html_e( 'If you select fixed fees type then : you have add fixed cost/fees (Eg. 10, 20) <br/>	
                                If you select percentage wise fees type then : you have add percentage (Eg. 10, 15.20)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>
                            </p>
                        </div>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row"><label
                                for="fee_settings_start_date"><?php esc_html_e( 'Start Date', 'woocommerce-conditional-product-fees-for-checkout' ); ?></label>
                    </th>
                    <td class="forminp mdtooltip">
                        <input type="text" name="fee_settings_start_date" class="text-class"
                               id="fee_settings_start_date"
                               value="<?php echo isset( $getFeesStartDate ) ? esc_attr( $getFeesStartDate ) : ''; ?>"
                               placeholder="<?php esc_html_e( 'Select start date', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                        <span class="woocommerce_conditional_product_fees_checkout_tab_descirtion"><i
                                    class="fa fa-question-circle " aria-hidden="true"></i></span>
                        <p class="description"><?php esc_html_e( 'Select start date which date product fee method will enable on website.', 'woocommerce-conditional-product-fees-for-checkout' ); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row"><label
                                for="fee_settings_end_date"><?php esc_html_e( 'End Date', 'woocommerce-conditional-product-fees-for-checkout' ); ?></label>
                    </th>
                    <td class="forminp mdtooltip">
                        <input type="text" name="fee_settings_end_date" class="text-class" id="fee_settings_end_date"
                               value="<?php echo isset( $getFeesEndDate ) ? esc_attr( $getFeesEndDate ) : ''; ?>"
                               placeholder="<?php esc_html_e( 'Select end date', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                        <span class="woocommerce_conditional_product_fees_checkout_tab_descirtion"><i
                                    class="fa fa-question-circle " aria-hidden="true"></i></span>
                        <p class="description"><?php esc_html_e( 'Select ending date which date product fee method will disable on website', 'woocommerce-conditional-product-fees-for-checkout' ); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row"><label
                                for="onoffswitch"><?php esc_html_e( 'Status', 'woocommerce-conditional-product-fees-for-checkout' ); ?></label>
                    </th>
                    <td class="forminp mdtooltip">
                        <label class="switch">
                            <input type="checkbox" name="fee_settings_status"
                                   value="on" <?php echo ( isset( $getFeesStatus ) && $getFeesStatus === 'off' ) ? '' : 'checked'; ?>>
                            <div class="slider round"></div>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label for="fee_settings_select_taxable"><?php esc_html_e( 'Is Amount Taxable ?', 'woocommerce-conditional-product-fees-for-checkout' ); ?></label>
                    </th>
                    <td class="forminp mdtooltip">
                        <select name="fee_settings_select_taxable" id="fee_settings_select_taxable" class="">
                            <option value="no" <?php echo isset( $getFeesTaxable ) && $getFeesTaxable === 'no' ? 'selected="selected"' : '' ?>><?php esc_html_e( 'No', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                            <option value="yes" <?php echo isset( $getFeesTaxable ) && $getFeesTaxable === 'yes' ? 'selected="selected"' : '' ?>><?php esc_html_e( 'Yes', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                        </select>
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="sub-title">
                <h2><?php esc_html_e( 'Conditional Fee Rule', 'woocommerce-conditional-product-fees-for-checkout' ); ?></h2>
                <div class="tap"><a id="fee-add-field" class="button button-primary button-large"
                                    href="javascript:;"><?php esc_html_e( '+ Add Row', 'woocommerce-conditional-product-fees-for-checkout' ); ?></a>
                </div>
            </div>
            <div class="tap">
                <table id="tbl-product-fee" class="tbl_product_fee table-outer tap-cas form-table product-fee-table">
                    <tbody>
					<?php
					if ( isset( $productFeesArray ) && ! empty( $productFeesArray ) ) {
						$i = 2;
						foreach ( $productFeesArray as $key => $productfees ) {
							$fees_conditions = isset( $productfees['product_fees_conditions_condition'] ) ? $productfees['product_fees_conditions_condition'] : '';
							$condition_is    = isset( $productfees['product_fees_conditions_is'] ) ? $productfees['product_fees_conditions_is'] : '';
							$condtion_value  = isset( $productfees['product_fees_conditions_values'] ) ? $productfees['product_fees_conditions_values'] : array();
							?>
                            <tr id="row_<?php esc_html_e( $i ); ?>" valign="top">
                                <th class="titledesc th_product_fees_conditions_condition" scope="row">
                                    <select rel-id="<?php esc_html_e( $i ); ?>"
                                            id="product_fees_conditions_condition_<?php esc_html_e( $i ); ?>"
                                            name="fees[product_fees_conditions_condition][]"
                                            id="product_fees_conditions_condition"
                                            class="product_fees_conditions_condition">
                                        <optgroup
                                                label="<?php esc_html_e( 'Location Specific', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                                            <option value="country" <?php echo ( $fees_conditions === 'country' ) ? 'selected' : '' ?>><?php esc_html_e( 'Country', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="state" <?php echo ( $fees_conditions === 'state' ) ? 'selected' : '' ?>
                                                    disabled><?php esc_html_e( 'State (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="postcode" <?php echo ( $fees_conditions === 'postcode' ) ? 'selected' : '' ?>
                                                    disabled><?php esc_html_e( 'Postcode (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="zone"
											        <?php echo ( $fees_conditions === 'zone' ) ? 'selected' : '' ?>disabled><?php esc_html_e( 'Zone (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </optgroup>
                                        <optgroup
                                                label="<?php esc_html_e( 'Product Specific', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                                            <option value="product" <?php echo ( $fees_conditions === 'product' ) ? 'selected' : '' ?>><?php esc_html_e( 'Product', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="category"
											        <?php echo ( $fees_conditions === 'category' ) ? 'selected' : '' ?>disabled><?php esc_html_e( 'Category (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="tag"
											        <?php echo ( $fees_conditions === 'tag' ) ? 'selected' : '' ?>disabled><?php esc_html_e( 'Tag (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </optgroup>
                                        <optgroup
                                                label="<?php esc_html_e( 'User Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                                disabled>
                                            <option value="user"><?php esc_html_e( 'User', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="user_role"><?php esc_html_e( 'User Role', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </optgroup>
                                        <optgroup
                                                label="<?php esc_html_e( 'Cart Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                                disabled>
											<?php
											$currency_symbol = get_woocommerce_currency_symbol();
											$currency_symbol = ! empty( $currency_symbol ) ? '(' . $currency_symbol . ')' : '';

											$weight_unit = get_option( 'woocommerce_weight_unit' );
											$weight_unit = ! empty( $weight_unit ) ? '(' . $weight_unit . ')' : '';
											?>
                                            <option value="cart_total" <?php echo ( $fees_conditions === 'cart_total' ) ? 'selected' : '' ?>><?php esc_html_e( 'Cart Subtotal (Before Discount) ', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php esc_html_e( $currency_symbol ); ?></option>
                                            <option value="cart_totalafter" <?php echo ( $fees_conditions === 'cart_totalafter' ) ? 'selected' : '' ?>><?php esc_html_e( 'Cart Subtotal (After Discount) ', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php esc_html_e( $currency_symbol ); ?></option>
                                            <option value="quantity" <?php echo ( $fees_conditions === 'quantity' ) ? 'selected' : '' ?>><?php esc_html_e( 'Quantity', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="weight" <?php echo ( $fees_conditions === 'weight' ) ? 'selected' : '' ?>><?php esc_html_e( 'Weight ', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php esc_html_e( $weight_unit ); ?></option>
                                            <option value="coupon" <?php echo ( $fees_conditions === 'coupon' ) ? 'selected' : '' ?>><?php esc_html_e( 'Coupon', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="shipping_class" <?php echo ( $fees_conditions === 'shipping_class' ) ? 'selected' : '' ?>><?php esc_html_e( 'Shipping Class', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </optgroup>
                                        <optgroup
                                                label="<?php esc_html_e( 'Payment Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                                disabled>
                                            <option value="payment" <?php echo ( $fees_conditions === 'payment' ) ? 'selected' : '' ?>><?php esc_html_e( 'Payment Gateway', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </optgroup>
                                        <optgroup
                                                label="<?php esc_html_e( 'Shipping Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                                disabled>
                                            <option value="shipping_method" <?php echo ( $fees_conditions === 'shipping_method' ) ? 'selected' : '' ?>><?php esc_html_e( 'Shipping Method', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </optgroup>
                                    </select>
                                </th>
                                <td class="select_condition_for_in_notin">
									<?php if ( $fees_conditions === 'cart_total' || $fees_conditions === 'cart_totalafter' || $fees_conditions === 'quantity' || $fees_conditions === 'weight' ) { ?>
                                        <select name="fees[product_fees_conditions_is][]"
                                                class="product_fees_conditions_is_<?php esc_html_e( $i ); ?>">
                                            <option value="is_equal_to" <?php echo ( $condition_is === 'is_equal_to' ) ? 'selected' : '' ?>><?php esc_html_e( 'Equal to ( = )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="less_equal_to" <?php echo ( $condition_is === 'less_equal_to' ) ? 'selected' : '' ?>><?php esc_html_e( 'Less or Equal to ( <= )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="less_then" <?php echo ( $condition_is === 'less_then' ) ? 'selected' : '' ?>><?php esc_html_e( 'Less than ( < )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="greater_equal_to" <?php echo ( $condition_is === 'greater_equal_to' ) ? 'selected' : '' ?>><?php esc_html_e( 'Greater or Equal to ( >= )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="greater_then" <?php echo ( $condition_is === 'greater_then' ) ? 'selected' : '' ?>><?php esc_html_e( 'Greater than ( > )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="not_in" <?php echo ( $condition_is === 'not_in' ) ? 'selected' : '' ?>><?php esc_html_e( 'Not Equal to ( != )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        </select>
									<?php } else { ?>
                                        <select name="fees[product_fees_conditions_is][]"
                                                class="product_fees_conditions_is_<?php esc_html_e( $i ); ?>">
                                            <option value="is_equal_to" <?php echo ( $condition_is === 'is_equal_to' ) ? 'selected' : '' ?>><?php esc_html_e( 'Equal to ( = )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                            <option value="not_in" <?php echo ( $condition_is === 'not_in' ) ? 'selected' : '' ?>><?php esc_html_e( 'Not Equal to ( != )', 'woocommerce-conditional-product-fees-for-checkout' ); ?> </option>
                                        </select>
									<?php } ?>
                                </td>
                                <td class="condition-value" id="column_<?php echo esc_attr( $i ); ?>">
									<?php
									$countries_obj = new WC_Countries();
									$getCountries  = $countries_obj->__get( 'countries' );
									global $post;
									if ( $fees_conditions === 'country' ) {
										?>

                                        <select name="fees[product_fees_conditions_values][value_<?php echo esc_attr( $i ); ?>][]"
                                                class="product_fees_conditions_values multiselect2 product_fees_conditions_values_country"
                                                multiple="multiple">
											<?php
											if ( ! empty( $getCountries ) ) {
												foreach ( $getCountries as $code => $country ) {
													$selectedVal = is_array( $condtion_value ) && ! empty( $condtion_value ) && in_array( $code, $condtion_value ) ? 'selected=selected' : '';
													?>
                                                    <option value="<?php echo esc_attr( $code ); ?>" <?php echo esc_attr( $selectedVal ); ?>><?php echo esc_html( $country ); ?></option>
													<?php
												}
											}
											?>
                                        </select>
										<?php

									} elseif ( $fees_conditions === 'product' ) {

										$get_all_products = new WP_Query( array(
											'post_type'      => 'product',
											'post_status'    => 'publish',
											'posts_per_page' => 500,
										) );
										?>
                                        <select id="product-filter" rel-id="<?php echo esc_attr( $i ); ?>"
                                                name="fees[product_fees_conditions_values][value_<?php echo esc_attr( $i ); ?>][]"
                                                class="product_fees_conditions_values multiselect2" multiple="multiple">
											<?php
											if ( $get_all_products->have_posts() ) {

												while ( $get_all_products->have_posts() ) {
													$get_all_products->the_post();
													$selectedVal = is_array( $condtion_value ) && ! empty( $condtion_value ) && in_array( $post->ID, $condtion_value ) ? 'selected=selected' : '';
													if ( $selectedVal !== '' ) { ?>
                                                        <option value="<?php echo esc_attr( $post->ID ); ?>" <?php echo esc_attr( $selectedVal ); ?>><?php esc_html_e( get_the_title() ); ?></option>
													<?php }
												}
											}
											?>
                                        </select>
									<?php } ?>
                                    <input type="hidden" name="condition_key[<?php echo 'value_' . esc_attr( $i ); ?>]"
                                           value="">
                                </td>
                                <td><a id="fee-delete-field" rel-id="<?php esc_html_e( $i ); ?>" class="delete-row"
                                       href="javascript:;" title="Delete"><i class="fa fa-trash"></i></a></td>
                            </tr>
							<?php
							$i ++;
						}
						?>
						<?php
					} else {
						$i = 1;
						?>
                        <tr id="row_1" valign="top">
                            <th class="titledesc th_product_fees_conditions_condition" scope="row">
                                <select rel-id="1" id="product_fees_conditions_condition_1"
                                        name="fees[product_fees_conditions_condition][]"
                                        id="product_fees_conditions_condition"
                                        class="product_fees_conditions_condition">
                                    <optgroup
                                            label="<?php esc_html_e( 'Location Specific', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                                        <option value="country"><?php esc_html_e( 'Country', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="state"
                                                disabled><?php esc_html_e( 'State (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="postcode"
                                                disabled><?php esc_html_e( 'Postcode (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="zone"
                                                disabled><?php esc_html_e( 'Zone (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    </optgroup>
                                    <optgroup
                                            label="<?php esc_html_e( 'Product Specific', 'woocommerce-conditional-product-fees-for-checkout' ); ?>">
                                        <option value="product"><?php esc_html_e( 'Product', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="category"
                                                disabled><?php esc_html_e( 'Category (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="tag"
                                                disabled><?php esc_html_e( 'Tag (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    </optgroup>
                                    <optgroup
                                            label="<?php esc_html_e( 'User Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                            disabled>
                                        <option value="user"><?php esc_html_e( 'User', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="user_role"><?php esc_html_e( 'User Role', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    </optgroup>
                                    <optgroup
                                            label="<?php esc_html_e( 'Cart Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                            disabled>
										<?php
										$currency_symbol = get_woocommerce_currency_symbol();
										$currency_symbol = ! empty( $currency_symbol ) ? '(' . $currency_symbol . ')' : '';

										$weight_unit = get_option( 'woocommerce_weight_unit' );
										$weight_unit = ! empty( $weight_unit ) ? '(' . $weight_unit . ')' : '';
										?>
                                        <option value="cart_total"><?php esc_html_e( 'Cart Subtotal (Before Discount) ', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php esc_html_e( $currency_symbol ); ?></option>
                                        <option value="cart_totalafter"><?php esc_html_e( 'Cart Subtotal (After Discount) ', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php esc_html_e( $currency_symbol ); ?></option>
                                        <option value="quantity"><?php esc_html_e( 'Quantity', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="weight"><?php esc_html_e( 'Weight', 'woocommerce-conditional-product-fees-for-checkout' ); ?><?php esc_html_e( $weight_unit ); ?></option>
                                        <option value="coupon"><?php esc_html_e( 'Coupon', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                        <option value="shipping_class"><?php esc_html_e( 'Shipping Class', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    </optgroup>
                                    <optgroup
                                            label="<?php esc_html_e( 'Payment Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                            disabled>
                                        <option value="payment"><?php esc_html_e( 'Payment Gateway', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    </optgroup>
                                    <optgroup
                                            label="<?php esc_html_e( 'Shipping Specific (Available in Pro Version)', 'woocommerce-conditional-product-fees-for-checkout' ); ?>"
                                            disabled>
                                        <option value="shipping_method"><?php esc_html_e( 'Shipping Method', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    </optgroup>
                                </select>
                            </td>
                            <td class="select_condition_for_in_notin">
                                <select name="fees[product_fees_conditions_is][]"
                                        class="product_fees_conditions_is product_fees_conditions_is_1">
                                    <option value="is_equal_to"><?php esc_html_e( 'Equal to ( = )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                    <option value="not_in"><?php esc_html_e( 'Not Equal to ( != )', 'woocommerce-conditional-product-fees-for-checkout' ); ?></option>
                                </select>
                            </td>
                            <td id="column_1" class="condition-value">
								<?php
								$countries_obj = new WC_Countries();
								$getCountries  = $countries_obj->__get( 'countries' );
								?>
                                <select name="fees[product_fees_conditions_values][value_1][]"
                                        class="product_fees_conditions_values multiselect2 product_fees_conditions_values_country"
                                        multiple="multiple">
									<?php
									if ( ! empty( $getCountries ) ) {
										foreach ( $getCountries as $code => $country ) {
											?>
                                            <option value="<?php echo esc_attr( $code ); ?>"><?php echo esc_html( $country ); ?></option>
											<?php
										}
									}
									?>
                                </select>
                                <input type="hidden" name="condition_key[value_1][]" value="">
                            </td>
                        </tr>
					<?php } ?>
                    </tbody>
                </table>
                <input type="hidden" name="total_row" id="total_row" value="<?php echo esc_attr( $i ); ?>">
            </div>
            <p class="submit"><input type="submit" name="submitFee" class="button button-primary button-large"
                                     value="<?php echo esc_attr( $btnValue ); ?>"></p>
        </form>
    </div>
<?php
include dirname( __FILE__ ) . '/header/plugin-sidebar.php';